uniform vec2 radius;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 color = gl_Color;
	float dy = uv.y / radius.y - 1.0;
	float dx1 = uv.x / radius.x - 1.0;
	float dx2 = (1.0-uv.x) / radius.x - 1.0;
	if (dy<0.0 && dx1<0.0)
		color.a = 1.0 - smoothstep(1.0, 1.2, dy*dy+dx1*dx1);
	else if (dy<0.0 && dx2<0.0)
		color.a = 1.0 - smoothstep(1.0, 1.2, dy*dy+dx2*dx2);
	gl_FragColor = color;
}
